/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.MyInputStream;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.Context;
import cds.allsky.Task;
import cds.fits.Fits;
import cds.moc.Moc;
import cds.moc.SMoc;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;

public class BuilderMoc
extends Builder {
    protected SMoc moc;
    protected int mocOrder;
    protected long maxSize = -1L;
    protected int fileOrder;
    protected int tileOrder;
    protected boolean isMocHight;
    protected boolean flagICRS;
    protected String ext = null;
    protected int frameCube = -1;
    long startTime = 0L;
    int nbTiles = -1;

    public BuilderMoc(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.MOC;
    }

    @Override
    public void run() throws Exception {
        this.createMoc(this.context.getOutputPath());
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        if (!this.context.verifTileOrder()) {
            throw new Exception("Uncompatible tileOrder !");
        }
    }

    public SMoc getMoc() {
        return this.moc;
    }

    protected void createMoc(String path) throws Exception {
        this.moc = new SMoc();
        this.fileOrder = this.mocOrder = Util.getMaxOrderByPath(path);
        this.tileOrder = this.context.getTileOrder();
        boolean bl = this.flagICRS = this.context.getFrame() == 0;
        if (!this.flagICRS) {
            this.mocOrder = this.fileOrder;
            this.context.warning("Non-equatorial HiPS (" + this.context.getFrameName() + ") => generating non standard galactic Moc.fits");
        } else if (this.context.getMocOrder() != -1) {
            this.mocOrder = this.context.getMocOrder();
        } else {
            this.mocOrder = this.fileOrder;
            if (this.mocOrder < 7) {
                this.mocOrder = 7;
            }
        }
        this.maxSize = this.context.getMocMaxSize();
        if (this.mocOrder > this.tileOrder + this.fileOrder) {
            this.context.warning("Too high mocOrder (" + this.mocOrder + ") => assume " + (this.tileOrder + this.fileOrder));
            this.mocOrder = this.tileOrder + this.fileOrder;
        }
        this.ext = this.getDefaultExt(path);
        String sinfo = this.ext == null ? "" : " based on " + this.ext + " tiles";
        this.frameCube = -1;
        if (this.context.getDepth() > 10) {
            this.frameCube = this.context.getDepth() / 2;
        }
        this.isMocHight = this.mocOrder > this.fileOrder && this.ext != null && this.ext.equals("fits");
        this.moc.setMocOrder(this.mocOrder);
        String outputFile = path + cds.tools.Util.FS + "Moc.fits";
        long t = System.currentTimeMillis();
        this.context.info("MOC generation" + sinfo + " (" + (this.isMocHight ? "deep resolution" : "regular resolution") + " mocOrder=" + this.moc.getMocOrder() + (this.maxSize != -1L ? " <" + cds.tools.Util.getUnitDisk(this.maxSize) : "") + ")...");
        String frame = this.getFrame();
        this.moc.setSpaceSys(frame);
        this.generateMoc(this.moc, this.fileOrder, path);
        if (this.flagICRS) {
            this.adjustSize(this.moc, true);
        }
        this.moc.write(outputFile);
        if (!this.flagICRS && !this.context.isMap()) {
            this.context.info("SMoc.fits generation (equatorial standard MOC) ...");
            Task.factoryRunner(this.context, Action.SMOC);
        }
        long time = System.currentTimeMillis() - t;
        this.context.info("MOC done in " + cds.tools.Util.getTemps(time * 1000L));
    }

    private String getDefaultExt(String path) {
        for (String ext : new String[]{"fits", "jpg", "png"}) {
            if (Context.findOneNpixFile(path, ext) == null) continue;
            return ext;
        }
        return null;
    }

    protected void initStat() {
        this.startTime = System.currentTimeMillis();
        this.nbTiles = 1;
    }

    protected void updateStat() {
        ++this.nbTiles;
    }

    @Override
    public void showStatistics() {
        long now = System.currentTimeMillis();
        long cTime = now - this.startTime;
        if (cTime < 2000L) {
            return;
        }
        this.context.stat(this.nbTiles + " tile" + (this.nbTiles > 1 ? "s" : "") + " scanned in " + cds.tools.Util.getTemps(cTime * 1000L));
    }

    public long getUsedArea() {
        return this.moc.getNbValues();
    }

    public long getArea() {
        return this.moc.maxVal();
    }

    protected boolean mustAdjustSize(Moc m, boolean force) {
        if (force) {
            m.flush();
        }
        return m.bufferSize() == 0;
    }

    protected void reduction(Moc m) throws Exception {
        m.reduction(this.maxSize);
    }

    protected void adjustSize(Moc m, boolean force) throws Exception {
        if (this.maxSize == -1L) {
            return;
        }
        if (!this.mustAdjustSize(m, force)) {
            return;
        }
        if (m.getMem() <= this.maxSize) {
            return;
        }
        this.reduction(m);
    }

    protected void generateMoc(SMoc moc, int fileOrder, String path) throws Exception {
        this.initStat();
        moc.bufferOn();
        File f = new File(path + Util.FS + "Norder" + fileOrder);
        File[] sf = f.listFiles();
        if (sf == null || sf.length == 0) {
            throw new Exception("No tiles found !");
        }
        for (int i = 0; i < sf.length; ++i) {
            if (this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            if (!sf[i].isDirectory()) continue;
            File[] sf1 = sf[i].listFiles();
            for (int j = 0; j < sf1.length; ++j) {
                String file = sf1[j].getAbsolutePath();
                long npix = Util.getNpixFromPath(file);
                if (npix == -1L) continue;
                String e = this.getExt(file);
                if (this.ext == null) {
                    this.ext = e;
                } else if (!this.ext.equals(e)) continue;
                if (this.frameCube > -1 && this.getCubeFrameNumber(file) != this.frameCube) continue;
                this.generateTileMoc(moc, sf1[j], fileOrder, npix);
            }
        }
        moc.bufferOff();
    }

    protected void generateTileMoc(SMoc moc, File f, int fileOrder, long npix) throws Exception {
        this.updateStat();
        if (this.isMocHight) {
            this.generateHighTileMoc(moc, fileOrder, f, npix);
        } else {
            moc.add(fileOrder, npix);
        }
        this.adjustSize(moc, false);
    }

    private void generateHighTileMoc(SMoc moc, int fileOrder, File f, long npix) throws Exception {
        Fits fits = new Fits();
        try (MyInputStream dis = null;){
            dis = new MyInputStream(new FileInputStream(f));
            dis = dis.startRead();
            fits.loadFITS(dis);
            dis.close();
            dis = null;
        }
        long nside = fits.width;
        long min = nside * nside * npix;
        int mocOrder = moc.getMocOrder();
        int tileOrder = (int)CDSHealpix.log2(nside);
        int div = (fileOrder + tileOrder - mocOrder) * 2;
        this.context.createHealpixOrder(tileOrder);
        long oNpix = -1L;
        for (int y = 0; y < fits.height; ++y) {
            for (int x = 0; x < fits.width; ++x) {
                try {
                    double pixel;
                    npix = min + (long)this.context.xy2hpx(y * fits.width + x);
                    if ((npix >>>= div) == oNpix || fits.isBlankPixel(pixel = fits.getPixelDouble(x, y))) continue;
                    moc.add(mocOrder, npix);
                    oNpix = npix;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected String getExt(String file) {
        int offset = file.lastIndexOf(46);
        if (offset == -1) {
            return "";
        }
        int pos = file.indexOf(Util.FS, offset);
        if (pos != -1) {
            return "";
        }
        return file.substring(offset + 1, file.length());
    }

    protected int getCubeFrameNumber(String file) {
        try {
            int fin = file.lastIndexOf(46);
            int deb = file.lastIndexOf(95, fin);
            if (deb == -1 || fin == -1) {
                return 0;
            }
            return Integer.parseInt(file.substring(deb + 1, fin));
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

